%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% making double contact
%% contact to double ellipse
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
k=0.8;
disp('started')
if 1==1
    % it is important to make it symetric
        distance=478; %nm distance between centers of the ellips
    % upper ellipse
        el_sizeNano=400; % in nm nanomagnet size
        el1_size=300; % in nm  size of contact
    el1_ratio=1.4;  % usualy 1.4 or 1/1.4  taht is x eliipse should be long
    el1_contact=[300 1200 100]; %%% Y length of contact electrode nm, X length should be less than ellipse!!!! width should be less or equal to ellips size
    el1_pad=[2500 2000];  % electrode pad 
   
    angleDown=80;
    angleUp=50;  % bigger ellipse
        % down ellipse
        el_sizeNanoD=el_sizeNano; % ellipse size
        el2_size=el1_size; % in nm
    el2_ratio=1.4;  % usualy 1.4 or 1/1.4  that is y ellipse should be close to circle
    %el2_contact=[el1_size*el1_ratio el1_contact(2)]; %%% Y length of contact electrode nm, X length should be less than ellipse!!!! width should be less or equal to ellips size
    el2_contact=[300 1200 100];  % upeper width;  length lower width
    el2_pad=el1_pad;  % electrode pad 
    
    EllipseInLineWidth=7; %nm
    PadsInLineWidth=8; %nm
    ContactInLineWidth=10; %nm
    InlineContactEllipse='non'; %'non'  'yes' use when problem with con
    InLineGap=15; % gap between inline and main area
    ElectrodesGap=4;
    DevideInline='yes';
    DoEllipseCenter='yes'; % 'yes' 'non'
    DoContactCenter='yes'; % 'yes' 'non'
    MyNameOld=['4D' num2str(el_sizeNano) 'L3'];
    
    DoDecompose='non';
    DecomExpWidthEl=3.75;  % nm A3 res 3.75
    DecomposRatioEl=4;  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidthEl=DecomExpWidthEl*(DecomposRatioEl-1);  % just monitor
    %for pads
        DecomExpWidth=3.75*4;  % nm A3 res 3.75
    DecomposRatio=4.6;  % how much average exp reduce A3 neg 4.45  pos 2.15
    DecomposNonWidth=DecomExpWidth*(DecomposRatioEl-1);  % just monitor
    
    
    
    %%%%%%%%%%%%%%%%%%%%
    xMax1=el_sizeNano*el1_ratio; yMax1=el_sizeNano/el1_ratio; % largest size of ellipse
    xMaxL1=xMax1-EllipseInLineWidth; yMaxL1=yMax1-EllipseInLineWidth;
    xMaxA1=xMaxL1-InLineGap; yMaxA1=yMaxL1-InLineGap;  % area size
    
    xMax2=el_sizeNanoD*el2_ratio; yMax2=el_sizeNanoD/el2_ratio; % largest size of ellipse
    xMaxL2=xMax2-EllipseInLineWidth; yMaxL2=yMax2-EllipseInLineWidth;
    xMaxA2=xMaxL2-InLineGap; yMaxA2=yMaxL2-InLineGap;  % area size
    %%%%%%%generate ellipse mag ellipse
    fi=2:2:358;
    for j=1:length(fi)
    Area1EllipseUp(j,1)=xMaxA1*0.5*cos(fi(j)*pi/180);
    Area1EllipseUp(j,2)=yMaxA1*0.5*sin(fi(j)*pi/180);  % diameter 1
    
   Area1EllipseDown(j,1)=xMaxA2*0.5*cos(fi(j)*pi/180);
    Area1EllipseDown(j,2)=yMaxA2*0.5*sin(fi(j)*pi/180);  % diameter 1
    
    Area1EllipseUp(j,2)=Area1EllipseUp(j,2)+distance/2 ; 
    Area1EllipseDown(j,2)=Area1EllipseDown(j,2)-distance/2;
    end  
        
     %figure(1);clf;hold on; plotJ01(Area1EllipseUp);plotJ01(Area1EllipseDown);hold off; return
   
        
 

    
    if DevideInline=='yes'
    %%%%% another inline (devided)
    angleToCut=90-angleUp;
    fi1=angleToCut:2:(180-angleToCut);
    
        for j=1:length(fi1)  % that is closer 
    SemiEllipseDown1(j,1)=xMax2*0.5*cos(fi1(j)*pi/180);
    SemiEllipseDown1(j,2)=yMax2*0.5*sin(fi1(j)*pi/180);  % 


    SemiEllipseDown1A(j,1)=xMaxL2*0.5*cos(fi1(j)*pi/180);
    SemiEllipseDown1A(j,2)=yMaxL2*0.5*sin(fi1(j)*pi/180);  % 
     
    end
    SemiEllipseDown1=[SemiEllipseDown1;flipud(SemiEllipseDown1A)];
    SemiEllipseDown1(:,2)=SemiEllipseDown1(:,2)-distance/2;
    %figure(1); plotJ01(SemiEllipseDown1); return
    
    
    fi2=(180-angleToCut):2:(360+angleToCut);
            for j=1:length(fi2)
    SemiEllipseDown2(j,1)=xMax2*0.5*cos(fi2(j)*pi/180);
    SemiEllipseDown2(j,2)=yMax2*0.5*sin(fi2(j)*pi/180);  % 

     
     SemiEllipseDown2A(j,1)=xMaxL2*0.5*cos(fi2(j)*pi/180);
    SemiEllipseDown2A(j,2)=yMaxL2*0.5*sin(fi2(j)*pi/180);  % 
     
    end
    SemiEllipseDown2=[SemiEllipseDown2;flipud(SemiEllipseDown2A)];
    SemiEllipseDown2(:,2)=SemiEllipseDown2(:,2)-distance/2;
    

   %figure(1);clf;hold on; plotJ01(SemiEllipseDown2);plotJ01(SemiEllipseDown1);hold off; return

  % figure(1);clf;hold on; plotJ01(SemiEllipseDown2);plotJ01(SemiEllipseDown1);plotJ01(Area1EllipseUp);plotJ01(Area1EllipseDown);hold off; return     

clear fi1; clear fi2;clear MySemiCircle1;clear MySemiCircle2;
 %% upper inline
angleToCut=90-angleDown;
fi1=-angleToCut:2:(180+angleToCut);

        for j=1:length(fi1)  % that is closer 
    SemiEllipseUp1(j,1)=xMax1*0.5*cos(fi1(j)*pi/180);
    SemiEllipseUp1(j,2)=yMax1*0.5*sin(fi1(j)*pi/180);  % 

    SemiEllipseUp1A(j,1)=xMaxL1*0.5*cos(fi1(j)*pi/180);
    SemiEllipseUp1A(j,2)=yMaxL1*0.5*sin(fi1(j)*pi/180); 
    end
    SemiEllipseUp1=[SemiEllipseUp1;flipud(SemiEllipseUp1A)];
    SemiEllipseUp1(:,2)=SemiEllipseUp1(:,2)+distance/2;
    %figure(1); plotJ01(SemiEllipseUp1); return
    
    
    
    fi2=(180+angleToCut):2:(360-angleToCut);
            for j=1:length(fi2)
    SemiEllipseUp2(j,1)=xMax1*0.5*cos(fi2(j)*pi/180);
    SemiEllipseUp2(j,2)=yMax1*0.5*sin(fi2(j)*pi/180);  % 
     
    SemiEllipseUp2A(j,1)=xMaxL1*0.5*cos(fi2(j)*pi/180);
    SemiEllipseUp2A(j,2)=yMaxL1*0.5*sin(fi2(j)*pi/180); 
    end
    SemiEllipseUp2=[SemiEllipseUp2;flipud(SemiEllipseUp2A)];
    SemiEllipseUp2(:,2)=SemiEllipseUp2(:,2)+distance/2;
    


%figure(1);clf;hold on; plotJ01(SemiEllipseUp1);plotJ01(SemiEllipseUp2);
%plotJ01(SemiEllipseDown1); plotJ01(SemiEllipseDown2);plotJ01(Area1EllipseDown); plotJ01(Area1EllipseUp);hold off; return
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   



   %%%%%%%%%%shifts
   if el_sizeNano*el1_ratio>el_sizeNanoD*el2_ratio; 
       Xmax=el_sizeNano*el1_ratio/2;
   else
       Xmax=el_sizeNanoD*el2_ratio/2;
   end
   if Xmax>2500
       MyShift(1)=Xmax;
   else
       MyShift(1)=2500;
   end

      if el_sizeNano/el1_ratio>el_sizeNanoD/el2_ratio; 
       Ymax=el_sizeNano/el1_ratio/2;
   else
       Ymax=el_sizeNanoD/el2_ratio/2;
   end
   if Ymax+distance/2>2500
       MyShift(2)=Ymax+distance/2;
   else
       MyShift(2)=2500;
   end
   
   MySizes(3)=MyShift(2)*k*2;MySizes(1)=MyShift(1)*k*2;MySizes(2)=0;MySizes(4)=0;
   
       


    
    if DevideInline=='yes'

    SemiEllipseUp1 (:,1)=SemiEllipseUp1 (:,1)+MyShift(1);SemiEllipseUp2(:,1)=SemiEllipseUp2(:,1)+MyShift(1);
    SemiEllipseUp1 (:,2)=SemiEllipseUp1 (:,2)+MyShift(2);SemiEllipseUp2(:,2)=SemiEllipseUp2(:,2)+MyShift(2);  
    SemiEllipseUp1 =SemiEllipseUp1 *k;SemiEllipseUp2=SemiEllipseUp2*k;
    SemiEllipseDown1 (:,1)=SemiEllipseDown1 (:,1)+MyShift(1);SemiEllipseDown2(:,1)=SemiEllipseDown2(:,1)+MyShift(1);
    SemiEllipseDown1 (:,2)=SemiEllipseDown1 (:,2)+MyShift(2);SemiEllipseDown2(:,2)=SemiEllipseDown2(:,2)+MyShift(2);
    SemiEllipseDown1 =SemiEllipseDown1 *k;SemiEllipseDown2=SemiEllipseDown2*k;
    SemiEllipseUp1=round(SemiEllipseUp1);SemiEllipseUp2=round(SemiEllipseUp2);SemiEllipseDown1=round(SemiEllipseDown1);SemiEllipseDown2=round(SemiEllipseDown2);
    Area1EllipseDown (:,1)=Area1EllipseDown (:,1)+MyShift(1);Area1EllipseUp(:,1)=Area1EllipseUp(:,1)+MyShift(1);
    Area1EllipseDown (:,2)=Area1EllipseDown (:,2)+MyShift(2);Area1EllipseUp(:,2)=Area1EllipseUp(:,2)+MyShift(2);  
    Area1EllipseDown =Area1EllipseDown *k;Area1EllipseUp=Area1EllipseUp*k;
    
    Y=RemoveRepeated(SemiEllipseUp1);clear SemiEllipseUp1; SemiEllipseUp1=Y; clear Y;
    Y=RemoveRepeated(SemiEllipseDown1);clear SemiEllipseDown1; SemiEllipseDown1=Y; clear Y;
    Y=RemoveRepeated(SemiEllipseUp2);clear SemiEllipseUp2; SemiEllipseUp2=Y; clear Y;
    Y=RemoveRepeated(SemiEllipseDown2);clear SemiEllipseDown2; SemiEllipseDown2=Y; clear Y;
    
    
       if  DoDecompose=='yes'
           if DoEllipseCenter=='yes'
   DecoArea1EllipseDown=DecomposCircle(Area1EllipseDown,EllipDownNorm, DecomExpWidthEl,DecomposRatioEl,k);
   DecoArea1EllipseUp=DecomposCircle(Area1EllipseUp,EllipUpNorm, DecomExpWidthEl,DecomposRatioEl,k);
            end
   end
    
    Area1EllipseDown =round(Area1EllipseDown );Area1EllipseUp=round(Area1EllipseUp);
    %figure(1);plotJ01(SemiEllipseUp1); hold on; plotJ01(SemiEllipseUp2);plotJ01(SemiEllipseDown1); plotJ01(SemiEllipseDown2);hold off; return

    end
    
    
    
    
        Y=RemoveRepeated(Area1EllipseUp);clear Area1EllipseUp; Area1EllipseUp=Y; clear Y;
   Y=RemoveRepeated(Area1EllipseDown);clear Area1EllipseDown; Area1EllipseDown=Y; clear Y;
    
    
     global plotJ01UseFill
    if DevideInline=='yes'
             plotJ01UseFill=1;   % use plot with fill
            global plotJ01Color
            figure(3); clf;hold on;
            plotJ01Color='y'; %area
               if DoEllipseCenter=='yes'; 
                        if  DoDecompose=='yes'
                       for j=1:length(DecoArea1EllipseUp);plotJ01(DecoArea1EllipseUp{j}); end
                       for j=1:length(DecoArea1EllipseDown);plotJ01(DecoArea1EllipseDown{j}); end
                   else
                       plotJ01(Area1EllipseUp); plotJ01(Area1EllipseDown);
                        end
              end;
            plotJ01Color='r'; %line extra
            plotJ01(SemiEllipseUp1); plotJ01(SemiEllipseDown2);
            plotJ01Color='g'; %line extra
            plotJ01(SemiEllipseDown1); plotJ01(SemiEllipseUp2);
            grid on;;hold off; plotJ01UseFill=0; 
    else
    figure(3); clf;hold on;plotJ01(MagEllipseUpArea); plotJ01(MagEllipseDownArea);  ;hold off; 
    figure(4); clf;hold on;plotJ01(MagEllipseUpLine); plotJ01(MagEllipseDownLine);  ;hold off; 
    end
    
    gapMagnet=distance-(el_sizeNano/el1_ratio+el_sizeNanoD/el2_ratio)/2

MyName= MyNameOld;
    MyNameS=['ID/VZ_' MyName '\n'];
    myFileName=['VZ_' MyName '.j01'];
    fid = fopen(myFileName,'w');

  PrintSizesToFile;
      if DevideInline=='yes'
fprintf(fid,['*  DOUBLE INLINE  \n']); 
        end
     fprintf(fid,['*  double nanomagnets of size' num2str(el_sizeNano) ' nm ratio ' num2str(el1_ratio) ' \n']);
     fprintf(fid,['*  upper ellipse size ' num2str(el_sizeNano) ' nm ratio ' num2str(el1_ratio) ' \n']);
     fprintf(fid,['*  lower ellipse size ' num2str(el_sizeNanoD) ' nm ratio ' num2str(el2_ratio) ' \n']);
     fprintf(fid,['*  upper ellipse area ' num2str(pi*(el_sizeNano/2)^2*1E-6) ' um2  \n']);
       fprintf(fid, ['* distance between centers ' num2str(distance) ' nm closest gap between contacts ' num2str(gapMagnet) ' nm  \n']);
      fprintf(fid,['*inline ellipse ' num2str(EllipseInLineWidth) ' nm  inline gap ' num2str(InLineGap) ' nm \n']);
           if  DoDecompose=='yes'
    fprintf(fid,['* sq decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
    fprintf(fid,['* el decompos ratio' num2str(DecomposRatioEl) '  exp width ' num2str(DecomExpWidthEl) '  non width ' num2str(DecomposNonWidthEl) ' nm \n']);
    end 
       
        fprintf(fid,MyNameS);

fprintf(fid,['* upper ellipse \n']);

    if DevideInline=='yes'
                                                   if DoEllipseCenter=='yes';
               fprintf(fid,'* upper ellipse area  \n');
                                       if  DoDecompose=='yes'                    
                       for j=1:length(DecoArea1EllipseUp);a=DecoArea1EllipseUp{j};MyLayer=1; PrintToJ01; end
                                     else;a=Area1EllipseUp;MyLayer=1; PrintToJ01;
                                      end
                   fprintf(fid,'* lower ellipse area  \n');   
                                     if  DoDecompose=='yes'                    
                       for j=1:length(DecoArea1EllipseDown);a=DecoArea1EllipseDown{j};MyLayer=1; PrintToJ01; end
                                     else;a=Area1EllipseDown;MyLayer=1; PrintToJ01;
                                      end
                        end

                                                         end

     fprintf(fid,'* upper ellipse Line out  \n');
    a=SemiEllipseUp1;MyLayer=2; PrintToJ01;
    fprintf(fid,'* upper ellipse Line in  \n');
    a=SemiEllipseUp2;MyLayer=3; PrintToJ01;
     fprintf(fid,'* down ellipse Line in  \n');
    a=SemiEllipseDown1;MyLayer=3; PrintToJ01;
    fprintf(fid,'* down ellipse Line out  \n');
    a=SemiEllipseDown2;MyLayer=2; PrintToJ01;
    else
               fprintf(fid,'* upper ellipse area  \n');
    a=MagEllipseUpArea;MyLayer=1; PrintToJ01;
       fprintf(fid,'* lower ellipse area  \n');
    a=MagEllipseDownArea;MyLayer=1; PrintToJ01;
     fprintf(fid,'* upper ellipse Line  \n');
    a=MagEllipseUpLine;MyLayer=2; PrintToJ01;
    fprintf(fid,'* lower ellipse Line  \n');
    a=MagEllipseDownLine;MyLayer=2; PrintToJ01;
    end

    fprintf(fid,'EF');
    fclose(fid);
    
    
    
    %%%%%%%%%%%%making contacts
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     %upper electrode contact
         %%%%%%%generate ellipse mag ellipse
    fi=2:2:358;
    for j=1:length(fi)
    MyCircle(j,1)=0.5*cos(fi(j)*pi/180);
    MyCircle(j,2)=0.5*sin(fi(j)*pi/180);  % diameter 1
    end
    
    MyObj2(:,1)=el1_size*MyCircle(:,1)*el1_ratio; 
    MyObj2(:,2)=el1_size*MyCircle(:,2)/el1_ratio ; 
   %%%%%%%
JJ=length(MyObj2(:,1));
for j=2:JJ
    if MyObj2(j,1)>MyObj2(j-1,1)
        jj1=j;
        break
    end
end

for j=jj1-1:-1:1
    if MyObj2(j,1)>-el1_contact(1)/2
        jjL=j;
        break
    end
end
for j=1:jj1
    if MyObj2(j,1)<el1_contact(1)/2
        jjR=j;
        break
    end
end

if jjR==1 
    MyEllipse(:,:)=MyObj2(jj1:JJ,:);
else
MyEllipse(:,1)=[ MyObj2(jjL-1:JJ,1);MyObj2(1:jjR,1)];
MyEllipse(:,2)=[ MyObj2(jjL-1:JJ,2); MyObj2(1:jjR,2)];
end
clear MyObj2
MyObj2(:,1)=[MyEllipse(1,1); MyEllipse(:,1) ;MyEllipse(length(MyEllipse(:,1)),1)];
MyObj2(:,2)=[el1_contact(2); MyEllipse(:,2); el1_contact(2)];


SmallContactUp(:,1)=[-el1_contact(1)/2;-el1_contact(3)/2; -el1_contact(3)/2;el1_contact(3)/2; el1_contact(3)/2;el1_contact(1)/2];
SmallContactUp(:,2)=[el1_contact(2); el1_contact(2)/4; MyEllipse(1,2); MyEllipse(1,2) ;el1_contact(2)/4;  el1_contact(2)];


%SmallContactDown(:,1)=[-el2_contact(1)/2;-el2_contact(3)/2; -el2_contact(3)/2;el2_contact(3)/2; el2_contact(3)/2;el2_contact(1)/2;];
%SmallContactDown(:,2)=[el2_contact(2);el2_contact(2)/2; MyEllipseDown(1,2); MyEllipseDown(1,2) ; el2_contact(2)/2;;el2_contact(2)];

%SmallContactUp(:,1)=[-el1_contact(1)/2; MyEllipse(1,1); MyEllipse(1,1);MyEllipse(length(MyEllipse(:,1)),1); MyEllipse(length(MyEllipse(:,1)),1); el1_contact(1)/2;];
%SmallContactUp(:,2)=[el1_contact(2); el1_contact(2)/2; MyEllipse(1,2); MyEllipse(1,2) ;el1_contact(2)/2;  el1_contact(2)];


clear MyObj1
MyObj1(:,1)=[-el1_pad(1)/2; MyEllipse(1,1); MyEllipse(:,1) ; MyEllipse(length(MyEllipse(:,1)),1); el1_pad(1)/2];
MyObj1(:,2)=[el1_contact(2); el1_contact(2); MyEllipse(:,2); el1_contact(2); el1_contact(2)];

clear MyObj2
MyObj2(:,1)=[MyObj1(1,1); MyObj1(:,1) ;MyObj1(length(MyObj1(:,1)),1)];
MyObj2(:,2)=[MyObj1(1,2)+el1_pad(2); MyObj1(:,2); MyObj1(length(MyObj1(:,2)),2)+el1_pad(2)];

UpperPad(:,1)=[MyObj1(1,1); -el1_contact(1)/2;el1_contact(1)/2;MyObj1(length(MyObj1(:,1)),1)];
UpperPad(:,2)=[MyObj1(1,2)+el1_pad(2); MyObj1(1,2); MyObj1(1,2); MyObj1(1,2)+el1_pad(2)];

MyElect=MyObj2;;
%figure(1); clf;plot(MyEllipse(:,1),MyEllipse(:,2), SmallContact(:,1),SmallContact(:,2), UpperPad(:,1),UpperPad(:,2)); return
clear MyObj2; clear MyObj1
%figure(1); clf;plot(MyElect(:,1),MyElect(:,2)); return
UpperPad(:,2)=UpperPad(:,2)+distance/2;SmallContactUp(:,2)=SmallContactUp(:,2)+distance/2;MyElect(:,2)=MyElect(:,2)+distance/2;
if UpperPad(1,2)>2500
    UpperPad(1,2)=2500;
    UpperPad(4,2)=2500;
end


MyEllipse(:,2)=MyEllipse(:,2)+distance/2;
 %%%%%%%%%%%%%%%%%%%%%%%%down contact
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % no shift yet
    MyObj2(:,1)=el2_size*MyCircle(:,1)*el2_ratio; 
    MyObj2(:,2)=el2_size*MyCircle(:,2)/el2_ratio ; 
   %%%%%%%
JJ=length(MyObj2(:,1));
for j=2:JJ
    if MyObj2(j,1)>MyObj2(j-1,1)
        jj1=j;
        break
    end
end

for j=jj1-1:-1:1
    if MyObj2(j,1)>-el1_contact(1)/2
        jjL=j;
        break
    end
end
for j=1:jj1
    if MyObj2(j,1)<el1_contact(1)/2
        jjR=j;
        break
    end
end

if jjR==1 
    MyEllipseDown(:,:)=MyObj2(jj1:JJ,:);
else
MyEllipseDown(:,1)=[ MyObj2(jjL-1:JJ,1);MyObj2(1:jjR,1)];
MyEllipseDown(:,2)=[ MyObj2(jjL-1:JJ,2); MyObj2(1:jjR,2)];
end
%figure(1);plot(MyEllipseDown(:,1) ,MyEllipseDown(:,2) );return
clear MyObj2
MyObj2(:,1)=[MyEllipseDown(1,1); MyEllipseDown(:,1) ;MyEllipseDown(length(MyEllipseDown(:,1)),1)];
MyObj2(:,2)=[el2_contact(2); MyEllipseDown(:,2); el2_contact(2)];


%SmallContactDown(:,1)=[el2_contact(1);MyEllipseDown(1,1); MyEllipseDown(1,1);MyEllipseDown(length(MyEllipseDown(:,1)),1); MyEllipseDown(length(MyEllipseDown(:,1)),1);el2_contact(1);];
%SmallContactDown(:,2)=[el2_contact(2);el2_contact(2)/2; MyEllipseDown(1,2); MyEllipseDown(1,2) ;el2_contact(2)/2; el2_contact(2)];

%SmallContactDown(:,1)=[MyEllipseDown(1,1); MyEllipseDown(1,1);MyEllipseDown(length(MyEllipseDown(:,1)),1); MyEllipseDown(length(MyEllipseDown(:,1)),1)];;
%SmallContactDown(:,2)=[el2_contact(2);MyEllipseDown(1,2); MyEllipseDown(1,2) ;el2_contact(2)];

%SmallContactDown(:,1)=[-el2_contact(1)/2;MyEllipseDown(1,1); MyEllipseDown(1,1);MyEllipseDown(length(MyEllipseDown(:,1)),1); MyEllipseDown(length(MyEllipseDown(:,1)),1);el2_contact(1)/2;];
%SmallContactDown(:,2)=[el2_contact(2);el2_contact(2)/2; MyEllipseDown(1,2); MyEllipseDown(1,2) ; el2_contact(2)/2;;el2_contact(2)];

SmallContactDown(:,1)=[-el2_contact(1)/2;-el2_contact(3)/2; -el2_contact(3)/2;el2_contact(3)/2; el2_contact(3)/2;el2_contact(1)/2;];
SmallContactDown(:,2)=[el2_contact(2);   el2_contact(2)/4; MyEllipseDown(1,2); MyEllipseDown(1,2) ; el2_contact(2)/4;;el2_contact(2)];

if 1==0

figure(1); clf;hold on;plotJ01(SmallContactDown); ;;hold off; return
end

clear MyObj1
MyObj1(:,1)=[-el2_pad(1)/2; -el2_contact(1)/2; MyEllipseDown(:,1) ; el2_contact(1)/2; el2_pad(1)/2];
MyObj1(:,2)=[el2_contact(2); el2_contact(2); MyEllipseDown(:,2); el2_contact(2); el2_contact(2)];

clear MyObj2
MyObj2(:,1)=[MyObj1(1,1); MyObj1(:,1) ;MyObj1(length(MyObj1(:,1)),1)];
MyObj2(:,2)=[MyObj1(1,2)+el2_pad(2); MyObj1(:,2); MyObj1(length(MyObj1(:,2)),2)+el2_pad(2)];

%UpperPadDown(:,1)=[MyObj1(1,1); MyObj1(1,1); MyObj1(length(MyObj1(:,1)),1) ;MyObj1(length(MyObj1(:,1)),1)];
%UpperPadDown(:,2)=[MyObj1(1,2)+el2_pad(2); MyObj1(1,2); MyObj1(1,2); MyObj1(1,2)+el2_pad(2)];

UpperPadDown(:,1)=[MyObj1(1,1);  -el1_contact(1)/2;el1_contact(1)/2;MyObj1(length(MyObj1(:,1)),1)];
UpperPadDown(:,2)=[MyObj1(1,2)+el2_pad(2);  MyObj1(1,2);  MyObj1(1,2);MyObj1(1,2)+el2_pad(2)];

MyElectD=MyObj2;;
%figure(1); clf;plot(MyEllipse(:,1),MyEllipse(:,2), SmallContactDown(:,1),SmallContactDown(:,2), UpperPad(:,1),UpperPad(:,2)); return
clear MyObj2; clear MyObj1
%figure(1); clf;plot(MyElect(:,1),MyElect(:,2)); return
UpperPadDown(:,2)=UpperPadDown(:,2)+distance/2;SmallContactDown(:,2)=SmallContactDown(:,2)+distance/2;MyEllipseDown(:,2)=MyEllipseDown(:,2)+distance/2;MyElect(:,2)=MyElect(:,2)+distance/2;

% make all object with 5 um
if UpperPadDown(1,2)>2500
    UpperPadDown(1,2)=2500;UpperPadDown(4,2)=2500;
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%change direction of Down
if 1==0
JJ=length(UpperPadDown(:,1));
for j=1:JJ
MyBase1(JJ+1-j,:)=UpperPadDown(j,:);
end
UpperPadDown=MyBase1; clear MyBase1;

JJ=length(SmallContactDown(:,1));
for j=1:JJ
MyBase1(JJ+1-j,:)=SmallContactDown(j,:);
end
SmallContactDown=MyBase1; clear MyBase1;

JJ=length(MyEllipseDown(:,1));
for j=1:JJ
MyBase1(JJ+1-j,:)=MyEllipseDown(j,:);
end
MyEllipseDown=MyBase1; clear MyBase1;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%check before shift

if 1==0
TestMyEllipseDown=-MyEllipseDown*k;TestMyEllipseUp=MyEllipse*k;
figure(1); clf;hold on;plotJ01(TestEllipseUp); plotJ01(TestEllipseDown); plotJ01(TestMyEllipseDown); plotJ01(TestMyEllipseUp);;hold off; return
end
%%%%%%%%%%%%%%%%%%
%now shifts tempory assume that upper and down pad is equal
maxX=-UpperPad(1,1);
if maxX<2500
    MyShift(1)=2500;
else
    MyShift(1)=maxX;
end
MySizes(2)=(UpperPad(1,1)+MyShift(1))*k; MySizes(1)=(-UpperPad(1,1)+MyShift(1))*k;

maxY=UpperPad(1,2);
if maxY<2500
    MyShift(2)=2500;
else
    MyShift(2)=maxY;
end
MySizes(4)=(-UpperPad(1,2)+MyShift(2))*k; MySizes(3)=(UpperPad(1,2)+MyShift(2))*k;


UpperPadDown(:,1)=-UpperPadDown(:,1)+MyShift(1);SmallContactDown(:,1)=-SmallContactDown(:,1)+MyShift(1);MyEllipseDown(:,1)=-MyEllipseDown(:,1)+MyShift(1);
UpperPadDown(:,2)=-UpperPadDown(:,2)+MyShift(2);SmallContactDown(:,2)=-SmallContactDown(:,2)+MyShift(2);MyEllipseDown(:,2)=-MyEllipseDown(:,2)+MyShift(2);

UpperPad(:,1)=UpperPad(:,1)+MyShift(1);SmallContactUp(:,1)=SmallContactUp(:,1)+MyShift(1);MyEllipse(:,1)=MyEllipse(:,1)+MyShift(1);
UpperPad(:,2)=UpperPad(:,2)+MyShift(2);SmallContactUp(:,2)=SmallContactUp(:,2)+MyShift(2);MyEllipse(:,2)=MyEllipse(:,2)+MyShift(2);

UpperPadDown=UpperPadDown*k;SmallContactDown=SmallContactDown*k;MyEllipseDown=MyEllipseDown*k;
UpperPad=UpperPad*k; SmallContactUp=SmallContactUp*k;MyEllipse=MyEllipse*k;

%figure(1); clf;hold on;plotJ01(MyEllipse); plotJ01(SmallContactUp); plotJ01(UpperPad); plotJ01(MyEllipseDown);plotJ01(SmallContactDown); plotJ01(UpperPadDown);hold off; return
%%%%%
%%%%  inline Objects
[EllipseLine, EllipseArea]=InLineObject(MyEllipse,EllipseInLineWidth);
[SmallContactUpLine, SmallContactUpArea]=InLineObject(SmallContactUp,ContactInLineWidth);
[UpperPadLine, UpperPadArea]=InLineObject(UpperPad,PadsInLineWidth);
[EllipseDownLine, EllipseDownArea]=InLineObject(MyEllipseDown,EllipseInLineWidth);
[SmallContactDownLine, SmallContactDownArea]=InLineObject(SmallContactDown,ContactInLineWidth);
[UpperPadDownLine, UpperPadDownArea]=InLineObject(UpperPadDown,PadsInLineWidth);

[tmp123, UpperPadDownArea12]=InLineObject(UpperPadDownArea,ElectrodesGap);
clear tmp123; clear UpperPadDownArea; UpperPadDownArea=UpperPadDownArea12; clear UpperPadDownArea12;

[tmp123, UpperPadArea12]=InLineObject(UpperPadArea,ElectrodesGap);
clear tmp123; clear UpperPadArea; UpperPadArea=UpperPadArea12; clear UpperPadArea12;

if (el1_contact(3)-(ElectrodesGap+ContactInLineWidth))<30
   tmp123(:,1)=[SmallContactDownArea(1,1); SmallContactDownArea(2,1); SmallContactDownArea(5,1); SmallContactDownArea(6,1)]; 
    tmp123(:,2)=[SmallContactDownArea(1,2) ; SmallContactDownArea(2,2); SmallContactDownArea(5,2); SmallContactDownArea(6,2)]; 
    clear SmallContactDownArea; SmallContactDownArea=tmp123; clear tmp123;
end

 
if (el2_contact(3)-(ElectrodesGap+ContactInLineWidth))<30
       tmp123(:,1)=[SmallContactUpArea(1,1); SmallContactUpArea(2,1); SmallContactUpArea(5,1); SmallContactUpArea(6,1)]; 
    tmp123(:,2)=[SmallContactUpArea(1,2) ; SmallContactUpArea(2,2); SmallContactUpArea(5,2); SmallContactUpArea(6,2)]; 
    clear SmallContactUpArea; SmallContactUpArea=tmp123; clear tmp123;
end

[tmp123, SmallContactDownArea12]=InLineObject(SmallContactDownArea,ElectrodesGap);
clear tmp123; clear SmallContactDownArea; SmallContactDownArea=SmallContactDownArea12; clear SmallContactDownArea12;

[tmp123, SmallContactUpArea12]=InLineObject(SmallContactUpArea,ElectrodesGap);
clear tmp123; clear SmallContactUpArea; SmallContactUpArea=SmallContactUpArea12; clear SmallContactUpArea12;



EllipseLine=round(EllipseLine); EllipseArea =round(EllipseArea);SmallContactUpLine =round(SmallContactUpLine);
UpperPadLine =round(UpperPadLine);  EllipseDownLine =round(EllipseDownLine);EllipseDownArea =round(EllipseDownArea);
SmallContactDownLine=round( SmallContactDownLine); UpperPadDownLine =round(UpperPadDownLine);
MyEllipse=round(MyEllipse); MyEllipseDown=round(MyEllipseDown);
Y=RemoveRepeated(MyEllipse);clear MyEllipse; MyEllipse=Y; clear Y;
Y=RemoveRepeated(MyEllipseDown);clear MyEllipseDown; MyEllipseDown=Y; clear Y;

if  DoDecompose=='yes'
    DecUpperPadArea=Decompos([UpperPadArea(4,:); UpperPadArea(1:3,:)], DecomExpWidth,DecomposRatio,k);
    DecUpperPadDownArea=Decompos([UpperPadDownArea(4,:); UpperPadDownArea(1:3,:)], DecomExpWidth,DecomposRatio,k);
    DecSSmallContactUpArea=Decompos( SmallContactUpArea(2:5,:), DecomExpWidthEl,DecomposRatioEl,k);
    DecBSmallContactUpArea=Decompos([SmallContactUpArea(6,:);SmallContactUpArea(1:2,:); SmallContactUpArea(5,:)], DecomExpWidth,DecomposRatio,k);
    DecSSmallContactDownArea=Decompos(SmallContactDownArea(2:5,:), DecomExpWidthEl,DecomposRatioEl,k);
    DecBSmallContactDownArea=Decompos([SmallContactDownArea(6,:); SmallContactDownArea(1:2,:); SmallContactDownArea(5,:)], DecomExpWidth,DecomposRatio,k);
end

SmallContactUpArea=round( SmallContactUpArea);UpperPadArea =round(UpperPadArea);
SmallContactDownArea=round( SmallContactDownArea);UpperPadDownArea =round(UpperPadDownArea);


if InlineContactEllipse=='yes'
figure(1); clf;hold on;plotJ01(EllipseArea); plotJ01(SmallContactUpArea); plotJ01(UpperPadArea); plotJ01(EllipseDownArea);plotJ01(SmallContactDownArea); plotJ01(UpperPadDownArea);hold off; 

figure(2); clf;hold on;
plotJ01UseFill=1;   % use plot with fill
     global plotJ01Color
              plotJ01Color='y'; %area
if DoContactCenter=='yes'; plotJ01(MyEllipse);plotJ01(MyEllipseDown);end
if  DoDecompose=='yes'
    plotJ01(DecUpperPadArea);
    plotJ01(DecUpperPadDownArea);
    plotJ01(DecSSmallContactUpArea);
    plotJ01(DecSSmallContactUpArea);
    plotJ01(DecSSmallContactDownArea);plotJ01(DecBSmallContactDownArea);

else
plotJ01(UpperPadArea); plotJ01(SmallContactUpArea); plotJ01(SmallContactDownArea); plotJ01(UpperPadDownArea);
end
plotJ01Color='r'; %line
plotJ01(EllipseLine); plotJ01(SmallContactUpLine); plotJ01(UpperPadLine); plotJ01(EllipseDownLine);plotJ01(SmallContactDownLine); plotJ01(UpperPadDownLine);hold off; 

  hold off; grid on; plotJ01UseFill=0;             
else
figure(1); clf;hold on;; plotJ01(SmallContactUpArea); plotJ01(UpperPadArea); plotJ01(SmallContactDownArea); plotJ01(UpperPadDownArea);hold off; 

figure(2); clf;hold on;
     plotJ01UseFill=1;   % use plot with fill
     global plotJ01Color
              plotJ01Color='y'; %area
if DoContactCenter=='yes';plotJ01(MyEllipse);plotJ01(MyEllipseDown);end
plotJ01(UpperPadArea); plotJ01(SmallContactUpArea); plotJ01(SmallContactDownArea); plotJ01(UpperPadDownArea);
               plotJ01Color='r'; %line
 plotJ01(SmallContactUpLine); plotJ01(UpperPadLine); plotJ01(SmallContactDownLine); plotJ01(UpperPadDownLine);
hold off; grid on; plotJ01UseFill=0;

figure(4); clf;hold on;plotJ01(MyEllipse); plotJ01(SmallContactUpLine); plotJ01(UpperPadLine); plotJ01(MyEllipseDown);plotJ01(SmallContactDownLine); plotJ01(UpperPadDownLine)
plotJ01(SemiEllipseUp1);plotJ01(SemiEllipseUp2);plotJ01(SemiEllipseDown1); plotJ01(SemiEllipseDown2);plotJ01(Area1EllipseDown); plotJ01(Area1EllipseUp);
;hold off; 

end


gapElectrode=distance-(el1_size/el1_ratio+el2_size/el2_ratio)/2

MyName=['Con_' MyNameOld];
    MyNameS=['ID/VZ_' MyName '\n'];
    myFileName=['VZ_' MyName '.j01'];
    fid = fopen(myFileName,'w');

  PrintSizesToFile;
     fprintf(fid,['* contact to double nanomagnets for' MyNameOld ' nanocontact \n']);
       fprintf(fid, ['* distance between centers ' num2str(distance) ' nm ellipse size ' num2str(el1_size) ' nm  \n']);
       fprintf(fid,['* gap between contacts=' num2str(gapElectrode) ' nm \n']);
            fprintf(fid,['*inline ellipse ' num2str(EllipseInLineWidth) ' nm pads ' num2str(PadsInLineWidth) ' nm contact' num2str(ContactInLineWidth) ' nm \n']);
            if  DoDecompose=='yes'
    fprintf(fid,['* sq decompos ratio' num2str(DecomposRatio) '  exp width ' num2str(DecomExpWidth) '  non width ' num2str(DecomposNonWidth) ' nm \n']);
    fprintf(fid,['* el decompos ratio' num2str(DecomposRatioEl) '  exp width ' num2str(DecomExpWidthEl) '  non width ' num2str(DecomposNonWidthEl) ' nm \n']);
    end 
        fprintf(fid,MyNameS);

fprintf(fid,['* upper ellectrode \n']);
if InlineContactEllipse=='yes'
       fprintf(fid,'* ellipse area  \n');
    a=EllipseArea;MyLayer=1; PrintToJ01;
    fprintf(fid,'* ellipse Line  \n');
    a=EllipseLine;MyLayer=2; PrintToJ01;
else
    fprintf(fid,'* ellipse Line  \n');
    a=MyEllipse;MyLayer=2; PrintToJ01;
end


 
    fprintf(fid,'* small contact area  \n');
     if  DoDecompose=='yes'
    for j=1:length(DecSSmallContactUpArea);a=DecSSmallContactUpArea{j};MyLayer=1; PrintToJ01;end
    for j=1:length(DecBSmallContactUpArea);a=DecBSmallContactUpArea{j};MyLayer=1; PrintToJ01;end
    else;a=SmallContactUpArea;MyLayer=1; PrintToJ01;end
    
        fprintf(fid,'* upper pad area  \n');
         if  DoDecompose=='yes'
    for j=1:length(DecUpperPadArea);a=DecUpperPadArea{j};MyLayer=1; PrintToJ01;end
        else; a=UpperPadArea;MyLayer=1; PrintToJ01; end
   
        fprintf(fid,'* small contact Line  \n');
    a=SmallContactUpLine;MyLayer=2; PrintToJ01;
        fprintf(fid,'* upper pad Line  \n');
    a=UpperPadLine;MyLayer=2; PrintToJ01;
   %%%%%%%  lower electrodes
    fprintf(fid,['* lower ellectrode \n']);
    fprintf(fid,['* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% \n']);
    fprintf(fid,['* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% \n']);
if InlineContactEllipse=='yes'
       fprintf(fid,'* ellipse area  \n');
    a=EllipseDownArea;MyLayer=1; PrintToJ01;
    fprintf(fid,'* ellipse Line  \n');
    a=EllipseDownLine;MyLayer=2; PrintToJ01;
else
    fprintf(fid,'* ellipse Line  \n');
    a=MyEllipseDown;MyLayer=2; PrintToJ01;
end

    fprintf(fid,'* small contact area  \n');
     if  DoDecompose=='yes'
     for j=1:length(DecSSmallContactDownArea);a=DecSSmallContactDownArea{j};MyLayer=1; PrintToJ01; end
    for j=1:length(DecBSmallContactDownArea);a=DecBSmallContactDownArea{j};MyLayer=1; PrintToJ01; end
else;a=SmallContactDownArea;MyLayer=1; PrintToJ01; end
    
        fprintf(fid,'* upper pad area  \n');
         if  DoDecompose=='yes'
    for j=1:length(DecUpperPadDownArea);a=DecUpperPadDownArea{j};MyLayer=1; PrintToJ01; end
else; a=UpperPadDownArea;MyLayer=1; PrintToJ01; end
   
        fprintf(fid,'* small contact Line  \n');
    a=SmallContactDownLine;MyLayer=2; PrintToJ01;
        fprintf(fid,'* upper pad Line  \n');
    a=UpperPadDownLine;MyLayer=2; PrintToJ01;
    
    fprintf(fid,'EF');
    fclose(fid);return




    


